/**
 * @type {Record<string, Preset>}
 */
const ChannelPresetParams = {
  gravity: {
    key: 'gravity',
    name: '万有引力',
    params: [
      { label: '下单地址', key: 'order_url', value: '', help: '以 https:// 或 http:// 开头' },
      { label: '查询地址', key: 'query_url', value: '', help: '以 https:// 或 http:// 开头' },
      { label: '商户号', key: 'unique', value: '' },
      { label: '密钥', key: 'key', value: '' },
      { label: '通道编码', key: 'code', value: '' },
    ],
  },
}

/**
 * @typedef {("Input"|"InputNumber"|"Select")} RenderType
 * @typedef {{type:RenderType, props: Record<string, unknown>}} RenderOpt
 * @typedef {{label?:string, key:string, value: unknown, help?: string}} Param
 * @typedef {{key:string,name:string,params:Param[]}} Preset
 */
window.ChannelPresetParams = ChannelPresetParams
